/*! \file 
**********************************************************************************	
* Title:						Discretix SST mm API Source file						 					
*																			
* Filename:					    sst_api_mm.c															
*																			
* Project, Target, subsystem:	SST 6.0, Utility, API
* 
* Created:						19.08.2008														
*
* Modified:						19.08.2008										
*
* \Author						Miri S														
*																			
* \Remarks						
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/


/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "SEPDriver.h"
#include "error.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
#include "sst_types.h"
#include "sst_host_util.h"
#include "sst_host_def.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_test_flags.h"
#include "sst_host_op_code.h"

#include "NVS.h"

/*----------- Local include files -------------------------------------------*/
/*----------- Local Variable declarations -----------------------------------*/
/*----------- Local function declarations -----------------------------------*/
/*----------- Local constant definitions  -----------------------------------*/

/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/

/***** SST_MMGet *****/
DxError_t SST_MMGet(SSTMode_t *aCurrentMode_ptr)
{
    DxUint32_t              paramInBuffer_ptr [DX_1_WORD_PARAM];
    DxUint32_t              paramOutBuffer_ptr[DX_3_WORDS_PARAMS];
    DxError_t               errorRC;
	
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }

	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_MM_GET;

    
    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
								        /* Input buffer length */
								        DX_1_WORD_PARAM * sizeof(DxUint32_t), 
								        paramOutBuffer_ptr,
								        /* Output buffer maximal length */
								        DX_3_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_mm_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_MM_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_mm_get;
    }
    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_mm_get);
	 
	*aCurrentMode_ptr  = paramOutBuffer_ptr[2];
	
    
exit_mm_get: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
	
}

        
/***** SST_MMSet *****/
DxError_t SST_MMSet(SSTMode_t aNewMode)
{
    DxUint32_t              paramInBuffer_ptr [DX_2_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
	
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }

	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_MM_SET;

    /* Input Parameters */
    paramInBuffer_ptr[1] =  (DxUint32_t)aNewMode;     


    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
								        /* Input buffer length */
								        DX_2_WORDS_PARAMS * sizeof(DxUint32_t), 
								        paramOutBuffer_ptr,
								        /* Output buffer maximal length */
								        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_mm_set;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_MM_SET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_mm_set;
    }
    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_mm_set);
    
exit_mm_set: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
	
}
            


/***** SST_MMAuthSet *****/
DxError_t SST_MMAuthSet(SSTTxnId_t          aTransactionId,  
                        SSTHandle_t         aAuthHandle,
                        SSTMode_t           aNewMode,                        
                        DxByte_t           *aWorkspace_ptr,
                        DxUint32_t          aWorkspaceSizeInBytes)
{
    DxUint32_t              paramInBuffer_ptr [DX_5_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
	
	/* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }

	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_MM_AUTH_SET;
    
    /* Input Parameters */
    paramInBuffer_ptr[1] =  (DxUint32_t)aTransactionId;    
    paramInBuffer_ptr[2] =  (DxUint32_t)aAuthHandle.objDigest;
    paramInBuffer_ptr[3] =  (DxUint32_t)aAuthHandle.objId;
    paramInBuffer_ptr[4] =  (DxUint32_t)aNewMode;
        
    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
								        /* Input buffer length */
								        DX_5_WORDS_PARAMS * sizeof(DxUint32_t), 
								        paramOutBuffer_ptr,
								        /* Output buffer maximal length */
								        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_mm_auth_set;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_MM_AUTH_SET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_mm_auth_set;
    }
    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_mm_auth_set);
	 	
exit_mm_auth_set: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
	
}

/***** SST_MMPrivAuthCreate *****/
DxError_t SST_MMPrivAuthCreate(SSTTxnId_t          aTransactionId,
                               SSTSessionId_t      aSessionId,
                               SSTHandle_t        *aAuthHandle_ptr,                        
                               DxByte_t           *aWorkspace_ptr,
                               DxUint32_t          aWorkspaceSizeInBytes)
{
	DxUint32_t              paramInBuffer_ptr [DX_3_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_4_WORDS_PARAMS];
    DxError_t               errorRC;
	
	/* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }

	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_MM_PRIV_AUTH_CREATE;
    
    /* Input Parameters */
    paramInBuffer_ptr[1] =  (DxUint32_t)aTransactionId;    
    paramInBuffer_ptr[2] =  (DxUint32_t)aSessionId;    
        
    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
								        /* Input buffer length */
								        DX_3_WORDS_PARAMS * sizeof(DxUint32_t), 
								        paramOutBuffer_ptr,
								        /* Output buffer maximal length */
								        DX_4_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_mm_priv_auth_create;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_MM_PRIV_AUTH_CREATE)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_mm_priv_auth_create;
    }
    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_mm_priv_auth_create);
		 
	/* Fill out output parameters */
    aAuthHandle_ptr->objDigest = paramOutBuffer_ptr[2];
    aAuthHandle_ptr->objId     = paramOutBuffer_ptr[3];

	 	
exit_mm_priv_auth_create: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
	
}

/***** SST_MMPrivAuthOpen *****/
DxError_t SST_MMPrivAuthOpen(SSTSessionId_t    	aSessionId,
                             SSTHandle_t   		aAuthHandle,                        
                             DxByte_t     	   *aWorkspace_ptr,
                             DxUint32_t    		aWorkspaceSizeInBytes)
{
	DxUint32_t              paramInBuffer_ptr [DX_4_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;
	
	/* Eliminating warnings regarding useless variables */
    aWorkspace_ptr = aWorkspace_ptr;
    aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;
    
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }

	/* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_MM_PRIV_AUTH_OPEN;
    
    /* Input Parameters */
    paramInBuffer_ptr[1] =  (DxUint32_t)aSessionId;    
    paramInBuffer_ptr[2] =  (DxUint32_t)aAuthHandle.objDigest;
    paramInBuffer_ptr[3] =  (DxUint32_t)aAuthHandle.objId;
        
    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
								        /* Input buffer length */
								        DX_4_WORDS_PARAMS * sizeof(DxUint32_t), 
								        paramOutBuffer_ptr,
								        /* Output buffer maximal length */
								        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_mm_priv_auth_open;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_MM_PRIV_AUTH_OPEN)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_mm_priv_auth_open;
    }
    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_mm_priv_auth_open);		 	
	 	
exit_mm_priv_auth_open: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;	
}
